/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp;

import com.ibm.hsc.auiml.databeans.sfp.SFPBean;
import com.ibm.hsc.auiml.databeans.sfp.SFPSelectServiceableEventsCriteriaBean;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.sfp.SelectServiceableEvent;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.IntegerItemDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;

public class SFPServiceableEventOverviewBean
extends SFPBean
implements TaskSelectionListener {
    private transient ItemDescriptor[] m_idOverviewTable;
    private transient ColumnDescriptor[] m_cdOverviewTableStructure;
    private int[] m_iOverviewTableSelection;
    private static final String TRACE_MASKD = "JSEVENTD";
    private static final String TRACE_MASKF = "JSEVENTF";
    private static final String TRACE_MASKT = "JSEVENTT";
    private String[] problemKeys = null;
    private int[] problemNumber = null;
    private String[] pmhNumber = null;
    private String[] src = null;
    private String[] status = null;
    private LocalizableText[] firmwareFix = null;
    private long[] firstTimestamp = null;
    private long[] latestTimestamp = null;
    private String[] reportingName = null;
    private String[] reportingMTMS = null;
    private String[] failingMTMS = null;
    private String[] analyzingHMC = null;
    private String[] descriptiveText = null;
    private boolean[] callHomeCandidate = null;
    private SFPSelectServiceableEventsCriteriaBean criteria = null;
    private String[] selectedProblemKeys = null;
    LocalizableText openText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "OPEN_LBL");
    LocalizableText closedText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "CLOSED_LBL");
    private static final int PROBLEM_NUMBER_COLUMN = 0;
    private static final int PMH_NUMBER_COLUMN = 1;
    private static final int SRC_COLUMN = 2;
    private static final int STATUS_COLUMN = 3;
    private static final int FIRMWARE_FIX_COLUMN = 4;
    private static final int FIRST_TIMESTAMP_COLUMN = 5;
    private static final int LATEST_TIMESTAMP_COLUMN = 6;
    private static final int REPORTING_NAME_COLUMN = 7;
    private static final int REPORTING_MTMS_COLUMN = 8;
    private static final int FAILING_MTMS_COLUMN = 9;
    private static final int ANALYZING_HMC_COLUMN = 10;
    private static final int DESCRIPTIVE_TEXT_COLUMN = 11;
    private static final int NUM_COLUMNS = 12;
    private final String PROBLEM_NUMBER_COLUMN_STRING = String.valueOf(0);
    private final String PMH_NUMBER_COLUMN_STRING = String.valueOf(1);
    private final String SRC_COLUMN_STRING = String.valueOf(2);
    private final String STATUS_COLUMN_STRING = String.valueOf(3);
    private final String FIRMWARE_FIX_COLUMN_STRING = String.valueOf(4);
    private final String FIRST_TIMESTAMP_COLUMN_STRING = String.valueOf(5);
    private final String LATEST_TIMESTAMP_COLUMN_STRING = String.valueOf(6);
    private final String REPORTING_NAME_COLUMN_STRING = String.valueOf(7);
    private final String REPORTING_MTMS_COLUMN_STRING = String.valueOf(8);
    private final String FAILING_MTMS_COLUMN_STRING = String.valueOf(9);
    private final String ANALYZING_HMC_COLUMN_STRING = String.valueOf(10);
    private final String DESCRIPTIVE_TEXT_COLUMN_STRING = String.valueOf(11);
    public static final String TABLE_NAME = "EventTable";
    public static final String RESOURCE_NAME = "com.ibm.hsc.auiml.databeans.sfp.SFPServiceableEventOverviewAuiml";
    public static final String PANEL_NAME = "SFPServiceableEventOverview";
    private static final String OPEN_MARKER = "O";
    private static final String CLOSED_MARKER = "C";

    public SFPServiceableEventOverviewBean(PIProblem[] pIProblemArray, SFPSelectServiceableEventsCriteriaBean sFPSelectServiceableEventsCriteriaBean, boolean bl, boolean bl2) {
        super(bl, bl2);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewBean.c-tor()");
        }
        this.criteria = sFPSelectServiceableEventsCriteriaBean;
        int n = pIProblemArray == null ? 0 : pIProblemArray.length;
        this.problemKeys = new String[n];
        Arrays.fill(this.problemKeys, "");
        this.problemNumber = new int[n];
        this.pmhNumber = new String[n];
        Arrays.fill(this.pmhNumber, "");
        this.src = new String[n];
        Arrays.fill(this.src, "");
        this.status = new String[n];
        Arrays.fill(this.status, "");
        this.firmwareFix = new LocalizableText[n];
        Arrays.fill(this.firmwareFix, new LocalizableText(""));
        this.firstTimestamp = new long[n];
        this.latestTimestamp = new long[n];
        this.reportingName = new String[n];
        Arrays.fill(this.reportingName, "");
        this.reportingMTMS = new String[n];
        Arrays.fill(this.reportingMTMS, "");
        this.failingMTMS = new String[n];
        Arrays.fill(this.failingMTMS, "");
        this.analyzingHMC = new String[n];
        Arrays.fill(this.analyzingHMC, "");
        this.descriptiveText = new String[n];
        Arrays.fill(this.descriptiveText, "");
        this.callHomeCandidate = new boolean[n];
        for (int i = 0; i < n; ++i) {
            PIProblem pIProblem = pIProblemArray[i];
            if (pIProblem == null) continue;
            String string = pIProblem.getUniqueKey();
            if (string != null) {
                this.problemKeys[i] = string;
            }
            this.problemNumber[i] = pIProblem.getProblemNumber();
            string = pIProblem.getPMH();
            if (string != null) {
                this.pmhNumber[i] = string;
            }
            if ((string = pIProblem.getRefcode()) != null) {
                this.src[i] = string;
            }
            this.firstTimestamp[i] = pIProblem.getFirstReportedTimestamp();
            this.latestTimestamp[i] = pIProblem.getLastReportedTimestamp();
            if (this.firstTimestamp[i] <= 0L) {
                this.firstTimestamp[i] = this.latestTimestamp[i];
            } else if (this.latestTimestamp[i] <= 0L) {
                this.latestTimestamp[i] = this.firstTimestamp[i];
            }
            this.reportingName[i] = SelectServiceableEvent.getReportingName(pIProblem);
            this.reportingMTMS[i] = SelectServiceableEvent.getReportingMTMS(pIProblem);
            this.failingMTMS[i] = SelectServiceableEvent.getFailingMTMS(pIProblem);
            this.analyzingHMC[i] = SelectServiceableEvent.getAnalyzingHMC(pIProblem);
            this.status[i] = pIProblem.isProblemClosed() ? CLOSED_MARKER : OPEN_MARKER;
            string = pIProblem.getServiceableEventText();
            if (string != null) {
                this.descriptiveText[i] = string;
            }
            boolean bl3 = this.callHomeCandidate[i] = this.hasWriteAccess() && this.pmhNumber[i].length() == 0 && !pIProblem.isProblemClosed() && SelectServiceableEvent.callHomeEnabled(pIProblem);
            if (pIProblem.getProblemData() == null) continue;
            try {
                LocalizableText localizableText = (LocalizableText)pIProblem.getProblemData().get((Object)"pdc_FIRMWARE_FIX");
                if (localizableText == null) continue;
                this.firmwareFix[i] = localizableText;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewBean.c-tor()");
        }
    }

    public ColumnDescriptor[] getOverviewTableRowStructure() {
        return this.m_cdOverviewTableStructure;
    }

    public int getOverviewTableRowStatus() {
        return 3;
    }

    public int getOverviewTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getOverviewTableRowAt(int n) {
        return this.m_idOverviewTable;
    }

    public void setOverviewTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idOverviewTable = itemDescriptorArray;
    }

    public int[] getOverviewTableSelection() {
        return this.m_iOverviewTableSelection;
    }

    public void setOverviewTableSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iOverviewTableSelection = nArray;
    }

    public String[] getSelectedProblemKeys() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewBean.getSelectedProblemKeys()");
            Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewBean.getSelectedProblemKeys()");
        }
        return this.selectedProblemKeys;
    }

    public String[] getProblemKeys() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewBean.getProblemKeys()");
            Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewBean.getProblemKeys()");
        }
        return this.problemKeys;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }

    public void update(Object object) {
        super.update(object);
        if (object instanceof String) {
            String string = (String)object;
            if (Arrays.asList(this.problemKeys).contains(string)) {
                UserTaskManager userTaskManager = this.getUserTaskManager();
                for (int i = 0; i < this.problemKeys.length; ++i) {
                    ItemDescriptor[] itemDescriptorArray = userTaskManager.getRow(TABLE_NAME, i);
                    String string2 = (String)itemDescriptorArray[0].getUserObject();
                    if (!string2.equals(string)) continue;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "SFPServiceableEventOverviewBean.update() marking problem closed: " + string + " (row " + i + ")");
                    }
                    itemDescriptorArray[3].setTitle(this.closedText.toString());
                    itemDescriptorArray[3].setUserObject((Object)CLOSED_MARKER);
                    itemDescriptorArray[1].setUserObject((Object)Boolean.FALSE);
                    userTaskManager.setRow(TABLE_NAME, i, itemDescriptorArray);
                    break;
                }
            }
        }
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewBean.prepare()");
        }
        UserTaskManager userTaskManager = this.getUserTaskManager();
        try {
            while (true) {
                userTaskManager.removeRow(TABLE_NAME, 0);
            }
        }
        catch (Exception exception) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String string = this.openText.toString();
            String string2 = this.closedText.toString();
            int n = this.problemKeys.length;
            for (int i = 0; i < n; ++i) {
                String string3 = i + ".";
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[12];
                itemDescriptorArray[0] = new IntegerItemDescriptor(string3 + this.PROBLEM_NUMBER_COLUMN_STRING, this.problemNumber[i]);
                itemDescriptorArray[1] = new ItemDescriptor(string3 + this.PMH_NUMBER_COLUMN_STRING, this.pmhNumber[i]);
                itemDescriptorArray[1].setUserObject((Object)(this.callHomeCandidate[i] ? Boolean.TRUE : Boolean.FALSE));
                itemDescriptorArray[2] = new ItemDescriptor(string3 + this.SRC_COLUMN_STRING, this.src[i]);
                long l = this.firstTimestamp[i];
                long l2 = this.latestTimestamp[i];
                String string4 = l > 0L ? dateFormat.format(new Date(l)) : "";
                String string5 = l2 > 0L ? dateFormat.format(new Date(l2)) : "";
                itemDescriptorArray[5] = new ItemDescriptor(string3 + this.FIRST_TIMESTAMP_COLUMN_STRING, string4);
                itemDescriptorArray[6] = new ItemDescriptor(string3 + this.LATEST_TIMESTAMP_COLUMN_STRING, string5);
                itemDescriptorArray[7] = new ItemDescriptor(string3 + this.REPORTING_NAME_COLUMN_STRING, this.reportingName[i]);
                itemDescriptorArray[8] = new ItemDescriptor(string3 + this.REPORTING_MTMS_COLUMN_STRING, this.reportingMTMS[i]);
                itemDescriptorArray[9] = new ItemDescriptor(string3 + this.FAILING_MTMS_COLUMN_STRING, this.failingMTMS[i]);
                itemDescriptorArray[10] = new ItemDescriptor(string3 + this.ANALYZING_HMC_COLUMN_STRING, this.analyzingHMC[i]);
                itemDescriptorArray[3] = new ItemDescriptor(string3 + this.STATUS_COLUMN_STRING, this.status[i].equals(CLOSED_MARKER) ? string2 : string);
                itemDescriptorArray[3].setUserObject((Object)this.status[i]);
                itemDescriptorArray[4] = new ItemDescriptor(string3 + this.FIRMWARE_FIX_COLUMN_STRING, this.firmwareFix[i].toString());
                itemDescriptorArray[11] = new ItemDescriptor(string3 + this.DESCRIPTIVE_TEXT_COLUMN_STRING, this.descriptiveText[i]);
                itemDescriptorArray[0].setUserObject((Object)this.problemKeys[i]);
                userTaskManager.addRow(TABLE_NAME, i, itemDescriptorArray);
            }
            userTaskManager.setShown("Include1.CallHome", this.isManage());
            userTaskManager.setShown("Menu1.CallHome", this.isManage());
            userTaskManager.setShown("Include1.ManageProblemData", this.isManage());
            userTaskManager.setShown("Menu1.ManageProblemData", this.isManage());
            userTaskManager.setShown("Include1.CloseEvent", this.isManage());
            userTaskManager.setShown("Menu1.CloseEvent", this.isManage());
            userTaskManager.addTaskSelectionListener((TaskSelectionListener)this, TABLE_NAME);
            this.setTitle();
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewBean.prepare()");
            }
            return;
        }
    }

    public SFPSelectServiceableEventsCriteriaBean getCriteria() {
        return this.criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(TaskSelectionEvent taskSelectionEvent) {
        SFPServiceableEventOverviewBean sFPServiceableEventOverviewBean = this;
        synchronized (sFPServiceableEventOverviewBean) {
            int n;
            UserTaskManager userTaskManager;
            int[] nArray;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "->SFPServiceableEventOverviewBean.selectionChanged()");
            }
            boolean bl = (nArray = (userTaskManager = this.getUserTaskManager()).getSelectedRows(TABLE_NAME)) != null && nArray.length > 0;
            boolean bl2 = bl && nArray.length == 1;
            boolean bl3 = bl && this.hasWriteAccess();
            boolean bl4 = bl2 && bl3;
            boolean bl5 = bl && bl3;
            ItemDescriptor[] itemDescriptorArray = null;
            if (bl) {
                this.selectedProblemKeys = new String[nArray.length];
                for (n = 0; n < this.selectedProblemKeys.length; ++n) {
                    itemDescriptorArray = this.getUserTaskManager().getRow(TABLE_NAME, nArray[n]);
                    this.selectedProblemKeys[n] = (String)itemDescriptorArray[0].getUserObject();
                    if (!bl5 && !bl4) continue;
                    boolean bl6 = OPEN_MARKER.equals(itemDescriptorArray[3].getUserObject());
                    bl5 = bl5 && bl6;
                    bl4 = bl4 && bl6;
                }
            }
            n = bl2 && (Boolean)itemDescriptorArray[1].getUserObject() != false ? 1 : 0;
            userTaskManager.setEnabled("Include1.MenuDetails", bl2);
            userTaskManager.setEnabled("Menu1.MenuDetails", bl2);
            userTaskManager.setEnabled("Include1.CallHome", n != 0);
            userTaskManager.setEnabled("Menu1.CallHome", n != 0);
            userTaskManager.setEnabled("Include1.CloseEvent", bl5);
            userTaskManager.setEnabled("Menu1.CloseEvent", bl5);
            userTaskManager.setEnabled("Include1.ManageProblemData", bl2);
            userTaskManager.setEnabled("Menu1.ManageProblemData", bl2);
            userTaskManager.setEnabled("Include1.Repair", bl4);
            userTaskManager.setEnabled("Menu1.Repair", bl4);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPServiceableEventOverviewBean.selectionChanged()");
            }
        }
    }

    public String getPanelName() {
        return PANEL_NAME;
    }
}

